/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.items;

import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.TagTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.modules.filter.FilterModuleCache;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleContainer;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleInventory;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class FilterModuleItem
extends Item
implements ITooltipSettings,
ITooltipExtras {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/filtermodule");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null) {
            String blackListMode = tagCompound.m_128461_("blacklistMode");
            String modeLine = "Mode " + ("Black".equals(blackListMode) ? "blacklist" : "whitelist");
            if (tagCompound.m_128471_("damageMode")) {
                modeLine = modeLine + ", Damage";
            }
            if (tagCompound.m_128471_("nbtMode")) {
                modeLine = modeLine + ", NBT";
            }
            if (tagCompound.m_128471_("modMode")) {
                modeLine = modeLine + ", Mod";
            }
            return modeLine;
        }
        return "<not configured>";
    })});

    public FilterModuleItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(RFToolsBase.setup.getTab()));
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public void m_7373_(@Nonnull ItemStack itemStack, @Nullable Level worldIn, @Nonnull List<Component> list, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(itemStack, worldIn, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), itemStack, list, flagIn);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        ItemStack stack = player.m_21120_(hand);
        BlockPos pos = context.m_8083_();
        if (player.m_6047_()) {
            if (!world.f_46443_) {
                BlockEntity te = world.m_7702_(pos);
                if (InventoryTools.isInventory((BlockEntity)te)) {
                    FilterModuleInventory inventory = new FilterModuleInventory(stack);
                    InventoryTools.getItems((BlockEntity)te, s -> true).forEach(inventory::addStack);
                    inventory.markDirty();
                    player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Stored inventory contents in filter")), false);
                } else {
                    BlockState state = world.m_8055_(pos);
                    ItemStack blockStack = state.m_60734_().m_7397_((BlockGetter)world, pos, state);
                    if (!blockStack.m_41619_()) {
                        FilterModuleInventory inventory = new FilterModuleInventory(stack);
                        inventory.addStack(blockStack);
                        inventory.markDirty();
                        player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.GREEN + "Added " + blockStack.m_41786_().getString() + " to the filter!")), false);
                    } else {
                        player.m_5661_((Component)ComponentFactory.literal((String)(ChatFormatting.RED + "Could not add " + blockStack.m_41786_().getString() + " to the filter!")), false);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                @Nonnull
                public Component m_5446_() {
                    return ComponentFactory.literal((String)"Filter Module");
                }

                public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
                    FilterModuleContainer container = new FilterModuleContainer(id, player.m_142538_(), player);
                    container.setupInventories(null, playerInventory);
                    return container;
                }
            });
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static Predicate<ItemStack> getCache(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        return new FilterModuleCache(stack);
    }

    public List<Pair<ItemStack, Integer>> getItems(ItemStack stack) {
        FilterModuleInventory inventory = new FilterModuleInventory(stack);
        HashSet<Item> itemSet = new HashSet<Item>();
        for (ItemStack itemStack : inventory.getStacks()) {
            itemSet.add(itemStack.m_41720_());
        }
        for (TagKey tagKey : inventory.getTags()) {
            TagTools.getItemsForTag((TagKey)tagKey).forEach(i -> itemSet.add((Item)i.m_203334_()));
        }
        return itemSet.stream().map(item -> Pair.of((Object)new ItemStack((ItemLike)item), (Object)-2)).collect(Collectors.toList());
    }
}

